/* Copyright (C) 2016-2018 RealVNC Ltd.  All Rights Reserved.
 */

#ifndef EVENTHANDLEAUTOPTRQUEUE_H_262145854772826998248975209310676778675
#define EVENTHANDLEAUTOPTRQUEUE_H_262145854772826998248975209310676778675

#include <vnccommon/AutoPtrQueue.h>
#include <vnccommon/EventHandleTogglable.h>
#include <vnccommon/OptionalAutoPtr.h>

/**
 * \cond VNCCOMMON
 */
namespace vnccommon
{

/**
 * \brief The provided event handle is readable when there are items in the
 * queue.
 */
template<typename T>
class EventHandleAutoPtrQueue
{
    VNCCOMMON_DISALLOW_COPYING(EventHandleAutoPtrQueue);

public:
    EventHandleAutoPtrQueue()
    {
    }

    // Locking must be used when invoking these methods from multiple threads.

    void enqueue(std::auto_ptr<T> value)
    {
        mQueue.push(value);

        if(mQueue.size() == 1)
        {
            mEventHandle.set();
        }
    }

    OptionalAutoPtr<T> tryDequeue()
    {
        if(mQueue.isEmpty())
        {
            return OptionalAutoPtr<T>();
        }

        std::auto_ptr<T> value = mQueue.pop();

        if(mQueue.isEmpty())
        {
            mEventHandle.unset();
        }

        return OptionalAutoPtr<T>(value);
    }

    EventHandle getEventHandle() const
    {
        return mEventHandle.getEventHandle();
    }

    DirectedEventHandle getDirectedEventHandle() const
    {
        return mEventHandle.getDirectedEventHandle();
    }

private:
    EventHandleTogglable mEventHandle;
    AutoPtrQueue<T> mQueue;
};

}
/**
 * \endcond
 */


#endif // EVENTHANDLEAUTOPTRQUEUE_H_262145854772826998248975209310676778675

